// Autorise UNIQUEMENT le domaine de ton iframe
var ALLOWED_IFRAME_ORIGIN = "https://api.iassistant.shop";

window.addEventListener("message", function (e) {
  var data = e.data || {};
  if (e.origin !== ALLOWED_IFRAME_ORIGIN) return;

  // Ouvrir Stripe (Checkout/Portal) dans un nouvel onglet
  if (data.type === "IASSISTANT_CHECKOUT" && typeof data.url === "string") {
    try {
      window.open(data.url, "_blank", "noopener");
    } catch (err) {
      // fallback si popups bloquées
      window.location.href = data.url;
    }
  }
});

(function(){
    function showToast(txt){
        // Affiche ton message (ou ouvre le chat avec un message) — exemple très simple :
        alert(txt);
    }

    function checkHash(){
        const h = (window.location.hash || '').toLowerCase();
        if (h.includes('iassistant=success')) {
            showToast('Merci pour votre abonnement !');
            // retire le flag du hash pour éviter de le revoir
            history.replaceState(null, '', window.location.pathname + window.location.search);
        } else if (h.includes('iassistant=cancel')) {
            showToast('Abonnement annulé.');
            history.replaceState(null, '', window.location.pathname + window.location.search);
        }
    }

    window.addEventListener('hashchange', checkHash);
    checkHash();
})();