{* Container + styles *}
<style>
#{$ias_wrap_id|escape:'htmlall'} {
  position: fixed;
  right: 50px;
  bottom: 50px;
  z-index: 999999999999;
}
#{$ias_toggle_id|escape:'htmlall'} {
  position: absolute;
  right: 0;
  bottom: 0;
  width: 56px;
  height: 56px;
  border-radius: 50%;
  border: 0;
  background: #fff;
  box-shadow: 0 6px 20px rgba(0,0,0,.18);
  cursor: pointer;
  display: grid;
  place-items: center;
}

#{$ias_iframe_id|escape:'htmlall'} {
  display: none; /* fermé par défaut */
  width: 420px;
  height: 560px;
  border: 0;
  border-radius: 10px;
  background: #fff;
  box-shadow: 0 12px 32px rgba(0,0,0,.24);
}

/* Mode maximisé (reçu via postMessage) */
#{$ias_iframe_id|escape:'htmlall'}.ias-full {
  position: fixed;
  right: 24px;
  bottom: 24px;
  width: min(90vw, 1100px) !important;
  height: min(90vh, 900px) !important;
  z-index: 9999;
}
</style>

<div id="{$ias_wrap_id|escape:'htmlall'}" aria-live="polite">
  <iframe
    id="{$ias_iframe_id|escape:'htmlall'}"
    src="{$ias_chat_src|escape:'htmlall'}"
    data-admin-url="{$current_url_with_token|escape:'html'}"
    allow="clipboard-read; clipboard-write; fullscreen"
    referrerpolicy="strict-origin-when-cross-origin"
    title="iAssistant">
  </iframe>

  <button id="{$ias_toggle_id|escape:'htmlall'}"
          type="button"
          aria-controls="{$ias_iframe_id|escape:'htmlall'}"
          aria-expanded="false"
          title="{l s='Open iAssistant' mod='iassistant'}">
    <img src="{$ias_logo_url|escape:'htmlall'}" alt="iAssistant"/>
  </button>
</div>

{literal}
    <script>
        (function () {
            var btn   = document.getElementById("{/literal}{$ias_toggle_id|escape:'javascript'}{literal}");
            var frame = document.getElementById("{/literal}{$ias_iframe_id|escape:'javascript'}{literal}");
            if (!btn || !frame) return;

            var adminUrl = frame.dataset.adminUrl || '';

            document.getElementById("iassistant-chat").addEventListener("load", function() {
              this.contentWindow.postMessage(
                { type: "iassistant:handshake", adminUrl },
                "*"
              );
            });

            var open = false;
            function toggle() {
                open = !open;
                frame.style.display = open ? "block" : "none";
                btn.setAttribute("aria-expanded", open ? "true" : "false");
                btn.title = open ? "Fermer iAssistant" : "Ouvrir iAssistant";
                if (open) {
                  setTimeout(() => frame.contentWindow.postMessage({ type: 'chat:opened' }, '*'), 0);
                }
            }
            btn.addEventListener("click", function(e){ e.preventDefault(); toggle(); });
            document.addEventListener("keydown", function(ev){ if(open && ev.key === "Escape") toggle(); });

            // ⇣⇣ Gestion du redimensionnement demandé par l'iframe (postMessage) ⇣⇣
            window.addEventListener("message", function (e) {
                var d = e.data || {};
                if (d.type !== "iassistant:resize" || d.iframeId !== "{/literal}{$ias_iframe_id|escape:'javascript'}{literal}") return;

                // modes: "max", "normal", ou width/height directs
                if (d.mode === "max") {
                  frame.classList.add("ias-full");
                if (frame.style.display !== "block") { frame.style.display = "block"; }
                  btn.setAttribute("aria-expanded", "true");
                  return;
                }
                if (d.mode === "normal") {
                  frame.classList.remove("ias-full");
                  frame.style.width  = "420px";
                  frame.style.height = "560px";
                  return;
                }
                if (d.width)  frame.style.width  = String(d.width);
                if (d.height) frame.style.height = String(d.height);
            }, false);
        })();
    </script>
{/literal}